{include file='_head.tpl'}
{include file='_header.tpl'}

<!-- page header -->
<div class="ele_content page-header">
	<div class="circle-1"></div>
	<div class="circle-3"></div>
	<div class="container">
		<div class="inner">
			<div class="inner_inner">
				<h2>{__("Activation Required")}</h2>
				<p class="text-xlg">{__("You have to activate your account before you start")}</p>
			</div>
			<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path opacity="0.4" d="M19.7906 4.22007C16.8306 1.27007 12.0306 1.27007 9.09063 4.22007C7.02063 6.27007 6.40063 9.22007 7.20063 11.8201L2.50063 16.5201C2.17063 16.8601 1.94063 17.5301 2.01063 18.0101L2.31063 20.1901C2.42063 20.9101 3.09063 21.5901 3.81063 21.6901L5.99063 21.9901C6.47063 22.0601 7.14063 21.8401 7.48063 21.4901L8.30063 20.6701C8.50063 20.4801 8.50063 20.1601 8.30063 19.9601L6.36063 18.0201C6.07063 17.7301 6.07063 17.2501 6.36063 16.9601C6.65063 16.6701 7.13063 16.6701 7.42063 16.9601L9.37063 18.9101C9.56063 19.1001 9.88063 19.1001 10.0706 18.9101L12.1906 16.8001C14.7806 17.6101 17.7306 16.9801 19.7906 14.9301C22.7406 11.9801 22.7406 7.17007 19.7906 4.22007ZM14.5006 12.0001C13.1206 12.0001 12.0006 10.8801 12.0006 9.50007C12.0006 8.12007 13.1206 7.00007 14.5006 7.00007C15.8806 7.00007 17.0006 8.12007 17.0006 9.50007C17.0006 10.8801 15.8806 12.0001 14.5006 12.0001Z" fill="currentColor"/><path d="M14.5 12C15.8807 12 17 10.8807 17 9.5C17 8.11929 15.8807 7 14.5 7C13.1193 7 12 8.11929 12 9.5C12 10.8807 13.1193 12 14.5 12Z" fill="currentColor"/></svg>
		</div>
	</div>
</div>
<!-- page header -->

<!-- page content -->
<div class="container position-relative">
	<div class="ele_content text-center p-5">
		<h2>{__("Hey")} 👋 {__("Let's verify your")} {if $system['activation_type'] == "email"}{__("email")}{else}{__("phone")}{/if}</h2>
		<p class="text-xlg mt10 mb30">
            {if $system['activation_type'] == "email"}
              {__("Please go to")} <span class="text-primary">{$user->_data['user_email']}</span> {__("to complete the activation process")}
			  <br><br>
              {__("If you didn't receive the email, please check your spam/junk folder")}
            {else}
              {__("Please check the SMS on your phone")} <strong>{$user->_data['user_phone']}</strong> {__("to complete the activation process")}
            {/if}
		</p>

		<div>
            {if $system['activation_type'] == "email"}
				<button type="button" class="btn btn-success btn-mat mr10" data-toggle="modal" data-url="core/activation_email_resend.php">{__("Resend Verification Email")}</button>
				<button type="button" class="btn btn-primary btn-mat" data-toggle="modal" data-url="#activation-email-reset">{__("Change Email")}</button>
            {else}
				<button type="button" class="btn btn-success btn-mat mr10" data-toggle="modal" data-url="#activation-phone">{__("Enter Code")}</button>
				{if $user->_data['user_phone']}
					<button type="button" class="btn btn-primary btn-mat" data-toggle="modal" data-url="core/activation_phone_resend.php">{__("Resend SMS")}</button>
				{/if}
				<button type="button" class="btn btn-primary btn-mat" data-toggle="modal" data-url="#activation-phone-reset">{__("Change Phone Number")}</button>
            {/if}
		</div>
	</div>
</div>
<!-- page content -->

{include file='_footer.tpl'}